

/*
   Planet isosurface from Jaime Vives Piqueres's moon.

*/

// +w2304 +h1024

global_settings{
  //assumed_gamma 1
  max_trace_level 100 
  //radiosity{}
}
#default{texture{finish{ambient 0}}}
#include "functions.inc"


#declare ShowMedia=on;
#declare ShowPlanet=on;
#declare ShowWater=on;
#declare ShowClouds=on;
#declare ShowRings=on;


// *** PLANET Bue ***

#declare t_planet=
pigment{
           onion    warp { turbulence 0.01 /*lambda 33 */ }
           color_map{
                    [0 rgb .9]
                    [.6 rgb <.02,.01,.2>]
                    [.785 rgb <.6,.5,.4>]
                    [.79 rgb <.3,.2,.1>] // sand
                    [.805 rgb <0,.1,.2>]    // green
                    [.99 rgb <.02,.01,.2>]//<.1,.2,.01>]      // green    
                    [1 rgb <.6,.5,.4>]
                    }
                  scale 1/(<1.01,.995,1.01>)
                  }



#declare t_planet= // Bue texture
texture{
  pigment{
           onion    scale <1.01,.995,1.01>
           turbulence .0005
           lambda 2.5
           omega 1.2
           pigment_map{
                    [0 rgb 1]
                    [.05  t_planet ]
                    [.95  t_planet ] // sand
                    [1 rgb 1]//<.1,.2,.01>]
                    }
          }
        normal {agate scale .001}
        }  
        
#declare t_planet_Har=
texture{
pigment{
           onion    warp { turbulence 0.1 /*lambda 33 */ }
           pigment_map{
                    [0 rgb <2,1,0> ]
                    [.05 crackle scale .05 turbulence 0.1 colour_map{[0 rgb <1,0,0> ][1 rgb 0]}]//rgb <1,.5,0> ]  
                    
                    [1 rgb 0]    
                    }
                  //scale 1/(<1.01,.995,1.01>)
               }   


//#if(ShowMedia)
         //normal{granite .001 scale .00001}
//#end
//finish{specular .1 }
}

#declare Scalar=<4,1,4>;
#declare Rotar= <-15,0,0>; //<0,0,0>; //<60,0,16>; //<15,0,0>;//




        // }
#declare d_clouds=
//texture{
          density{
                   wrinkles  scale <100,50,100>*22
                   turbulence <1,2,1>
                   lambda 2.5
                   omega 1.3
                   warp { turbulence <10,0,10>*.1
                         //lambda 3
                         omega 1.2
                         }
                   density_map{
                            [0 rgb 0]
                            [.3 granite scale 1/(<100,50,100>*22) density_map{[0 rgb 0][.7 rgb 200]}]  
                            [1 rgb 200]
                            }
                   rotate y*15
                   scale<0.021,0.02,0.021>/Scalar
                   rotate -Rotar
                  }
#declare d_clouds2=
//texture{
          density{ wrinkles  rotate Rotar
                   scale Scalar
                   //lambda 2.5
                   omega 1.3
                   density_map{
                            [.1 rgb 0 ]
                            [.6 granite scale 3 density_map{
                                                [.5 rgb 0]
                                                [.7 granite scale .1 
                                                density_map{
                                                        [0 rgb 0]
                                                        [.7 granite scale .1 density_map{[.5 rgb 0][.6 rgb 10][1 rgb 200]}]
                                                        
                                                        [1 rgb 200]
                                                        }
                                                
                                                ] 
                                                
                                                [.8 rgb 100]
                                                [1 rgb 200]
                                                }
                            ]
                            //[.5 d_clouds]
                            //[.6 granite scale .1 density_map{[.5 rgb 0][.6 rgb 100]}]
                            
                            //[1 d_clouds] 
                            [1 rgb 0]
                            }
                   rotate y*-5
                   scale<0.021,0.02,0.021>/Scalar
                   rotate -Rotar
                  }


#declare d_clouds3=
//texture{
          density{
                   wrinkles  scale <100,50,100>*22
                   turbulence <1,2,1>
                   lambda 2.5
                   omega 1.3
                   warp { turbulence <10,0,10>*.1
                         //lambda 3
                         omega 1.2
                         }
                   density_map{
                            [0 rgb 0]
                            [.3 d_clouds2]  
                            [1 rgb 200]
                            }
                   rotate y*15
                   scale<0.021,0.02,0.021>/Scalar
                   rotate -Rotar
                  }

// Cloud texture 
#declare t_clouds1=
texture{
          pigment{
                   wrinkles  scale <100,50,100>*22
                   turbulence <1,2,1>
                   lambda 2.5
                   omega 1.3
                   warp { turbulence <10,0,10>*.1
                         //lambda 3
                         omega 1.2
                         }
                   color_map{
                            [0 rgb 1 transmit 1]
                            [.3 rgb 1 transmit .9]
                            [1 rgb 1 transmit 0]
                            }
                   rotate y*15
                   scale<0.021,0.02,0.021>/Scalar
                   rotate -Rotar
                  }
         }
#declare t_clouds=
texture{ wrinkles  rotate Rotar
                   scale Scalar
                   //lambda 2.5
                   omega 1.3
                   texture_map{
                            [0 t_clouds1 ]
                            [.3 pigment {rgb 1 transmit 1}]
                            [.5 t_clouds1]
                            [.7 pigment {rgb 1 transmit 1}]
                            [1 t_clouds1 ]
                            }
                  }

        // }
#declare t_smog=
texture{
          pigment{
                   wrinkles  scale <100,50,100>*22
                   turbulence <1,2,1>
                   lambda 2.5
                   omega 1.3
                   warp { turbulence <10,0,10>*.1
                         //lambda 3
                         omega 1.2
                         }
                   color_map{
                            [0 rgb 1 transmit 1]
                            //[.3 rgb <.3,.4,.1> transmit .9]
                            [1 rgb .5 transmit 0]
                            }
                   rotate y*15
                   scale<0.021,0.02,0.021>/Scalar
                    rotate -Rotar
                  }
         }
#declare t_smog=
texture{ wrinkles  rotate Rotar
                   scale Scalar
                   //lambda 2.5
                   omega 1.3
                   texture_map{
                            [0 t_clouds ]
                            [.3 pigment {rgb 1 transmit 1}]
                            [.5 t_clouds]
                            [.7 pigment {rgb 1 transmit 1}]
                            [1 t_clouds ]
                            }
                  }
// Terrain
#declare Terrain=isosurface{  // Copied from Jaime's LightSys Space Demo scene
 
function{(x*x+y*y+z*z-1)+f_granite(x*2,y*2,z*2)*f_agate(x,y,z)*.05}
                  //max_gradient 3.199
                  contained_by{sphere{0,1}}
                  
                  }


// Planet
#declare PlanetBue=
union{
         isosurface{  
 
        function{(x*x+y*y+z*z-1)
                  +f_granite(x*2,y*2,z*2)*f_agate(x,y,z)*.05
                  +f_agate(x*100,y*100,z*100)*.001
                  -f_granite(x*1000,y*1000,z*1000)*.0001
                  
                  }
                  //max_gradient 3.199 
                  accuracy 1/100000
                  contained_by{sphere{0,1}}
                   
                texture{t_planet 
                scale .02}
                  scale y*1.002
                  }


        #if(ShowWater)
                sphere{0,1 // water 
                  /*isosurface{  
 
                        function{(x*x+y*y+z*z-1) -f_granite(x,y,z)*.001 }
                                  //max_gradient 3.199 
                                  accuracy 1/1000000
                                  contained_by{sphere{0,1.1}} */
                       pigment{gradient y scale 2 translate y
                               turbulence .1
                                lambda 7
                              pigment_map{
                                       [0 rgbt<1,1,1,0> ]
                                       [.15 rgbft <0,.05,.2,.5,.5> 
                                       
                                       ]
                                       [.9 rgbft <0,.05,.2,.5,.5> 
                                       
                                       ]
                                       [1 rgbt<1,1,1,0> ]
                                       }
                               }
                        normal{granite  scale .0005 phase clock}  
                       #if(ShowMedia)
                          finish{//specular .1 metallic .5  
                                //reflection{.5,1 fresnel on} 
                                specular 1 metallic .8 
                                brilliance 4 conserve_energy
                                }
                          
                          interior{ior 1.33 fade_distance .003 fade_color rgb <0,0,.1>
                                        }
                       #end
                       scale .996
                       hollow
                       }
        #end
       #if(ShowMedia)
               
               sphere{0,1 // Atmosphere
                       pigment{colour rgbt 1}
                       interior{//ior 1.1
                                media {
                                   method 3     
                                   //adaptive sampling 
                                   aa_threshold 0.1 aa_level 3
                	           samples 20 //6 
                	           intervals 3 
                	           /*jitter .1*/  
                	           //variance 1.0/500
                	           scattering {4, rgb < 0.1, 0.4, 1>*3 extinction 1}
                                   absorption (1-< 0.1, 0.4, 0.9>)*.5              
                                   density {onion
                                            density_map{
                                                    [0 rgb <.001,.01,.1>]
                                                    [.96 rgb <.001,.01,.1>*2]
                                                    [.97 rgb 1]  // earth
                                                    //[.98 rgb .5]//
                                                    [.99 rgb .1]//
                                                    [1 rgb 0 ]//
                                                    }
                                           }
                                         } 
                                  /*       
                                  media {
                			method 3
                			samples 2 intervals 1
                			scattering {4, color rgb < 0.25, 0.6, 0.9>*0.00075 extinction 1}
                		        }*/       
                                #if(ShowClouds) 
                                    media {
                			method 3 aa_threshold 0.1 aa_level 3
                			samples 20//6 
                			intervals 3 
                			/*jitter .1*/
                			scattering {2, color rgb .9 extinction 1} 
                			absorption 50
                			density {d_clouds2}	
                			density {onion //warp{ turbulence .01 }
                				
                				density_map {
                					[.89  rgb 0]
                					[.979  rgb 0]
                					[.98  rgb 1]
                					[.988  rgb .035]
                					//[.989  rgb .1]
                					//[.99  rgb 0.035]
                					[.99  rgb 0]
                				}
                			
                			}
                			
                			/*
                			}
                			media {
                			method 3 //aa_threshold 0.1 aa_level 3
                			//samples 4 
                			intervals 1 
                			//jitter .1
                			scattering {2, color rgb .01 extinction 1} 
                			//absorption 30
                			density {d_clouds3}	
                			density {onion warp{ turbulence .01 }
                				
                				density_map {
                					//[.98  rgb 0]
                					[.9889  rgb 0]
                					[.989  rgb 1]
                					[.99  rgb 0]
                					//[1  rgb 0]
                				}
                			
                			}    
                			*/
                                #end
                                } }
                       rotate y*0
                       scale 1.03
                       hollow
                       double_illuminate
                       }
        #end
        #if(ShowClouds // *!ShowMedia 
                        )
               
        sphere{0,1.01 texture{t_clouds }
                       rotate y*0
                       hollow double_illuminate
                       }
         #end 
           
         
         sphere{0,1.025 pigment {rgbft<.9,.8,.1,1,.9>} 
               //rotate y*45
               hollow //double_illuminate
               }
        } 
        
        

// Planet
#declare PlanetHar=
union{
         object{Terrain 
                texture{t_planet_Har 
                scale .02}
                  scale y*1.002
                  }
      
       #if(ShowMedia)
               
               sphere{0,1 // Atmosphere
                       pigment{colour rgbt 1}
                       interior{
                                media {
                                   // (---general values---)
                                   intervals 10           // number of intervals used for sampling [10]
                                   samples 1,1            //minimum and maximum number of samples taken per interval [1,1]
                                   confidence 0.9         // statistic parameter higher->better quality [0.9]
                                   variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
                                   ratio 0.9              // distribution between lit and unlit areas [0.9]
                                   scattering {2, rgb 10 } 
                                   absorption 10
                                   //method 3               //adaptive sampling
                                   density {onion
                                            color_map{
                                                    [.89 rgb .5]  // earth
                                                    [.9 rgb <.15,.2,.05>]//
                                                    [.93 rgb <.1,.05,.02>]//
                                                    [1 rgb 0 ]//
                                                    }
                                           }
                                    }
                                }
                       rotate y*90
                       scale 1.04
                       hollow
                       double_illuminate
                       }
        #end
        #if(ShowClouds)
               
                       sphere{0,1.01 texture{t_clouds }
                       //rotate y*45
                       hollow 
                       double_illuminate
                       }
         #end    
         
         
                
        
        }

union{
// placement  of Planet Bue
union{  #if(ShowRings)
         disc {<0, 0, 0>  y, 1.0, .7        // -O- RINGs -O-   
         //torus{8.5,1.5 scale y*.00001
                         pigment{spherical
                                 cubic_wave
                                 colour_map{
                                            [0 rgbft <0,0,0, 1,1>]
                                            [.01 rgbft <.4,.3,.2, 0,.1>]
                                            [.015 rgbft <.3,.3,.3, .1,.7>]
                                            [.03 rgbft <.35,.3,.25, 0,.1>]
                                            [.04 rgbft <.1,.21,.3, .1,.9>]
                                            [.07 rgbft <.3,.21,.1, .2,.5>]
                                            //
                                            [.12 rgbft <.25,.2,.15, 0,.1>]
                                            [.12 rgbft <.25,.2,.15, 0,.1>]
                                            [.18 rgbft <.2,.2,.25, .1,.7>]
                                            [.20 rgbft <.3,.2,.1, 0,.1>]
                                            [.22 rgbft <0,0,0, 1,1>]
                                            }
                                 }
                         normal{granite .001 scale .00001}
                         finish{diffuse .7 roughness .9 brilliance .2 }
                         scale 2
                         hollow
                         //double_illuminate
                         //rotate <40,0,30>
                         }
          #end
         object{PlanetBue rotate y*4.9*0}
         scale .3 
         //rotate -<40,0,30>
         translate <0,0,0>
         }  
         
// placement  of planet Har
union{  #if(ShowRings)
         disc {<0, 0, 0>  y, 1.0, .7        // -O- RINGs -O- 
         //torus{8.5,1.5
                         pigment{spherical
                                 cubic_wave
                                 colour_map{
                                            [0 rgbft <0,0,0, 1,1>]
                                            [.01 rgbft <.4,.3,.2, 0,.1>]
                                            [.015 rgbft <.3,.3,.3, .1,.7>]
                                            [.03 rgbft <.35,.3,.25, 0,.1>]
                                            [.04 rgbft <.1,.21,.3, .1,.9>]
                                            [.07 rgbft <.3,.21,.1, .2,.5>]
                                            //
                                            [.12 rgbft <.25,.2,.15, 0,.1>]
                                            [.12 rgbft <.25,.2,.15, 0,.1>]
                                            [.18 rgbft <.2,.2,.25, .1,.7>]
                                            [.20 rgbft <.3,.2,.1, 0,.1>]
                                            [.22 rgbft <0,0,0, 1,1>]
                                            }
                                 }
                         normal{granite .001 scale .00001}
                         finish{diffuse .7 roughness .9 brilliance .2 }
                         scale 2
                         hollow
                         //double_illuminate
                         //rotate <40,0,30>
                         }
          #end
         object{PlanetHar rotate z*0}
         scale .3 
         //rotate -<40,0,30>
         translate <0,0,1.19>
         }
              
//scale (1/.3)*.2 translate <.6,0,-.6>         
}             
///////////////////////////////////////////////////
// moon

object{Terrain scale .4 rotate <-90,-90,-90> rotate <0,35,0> pigment{rgb .2} translate <0,1.5,3>}

/////////////// New Addition by Nekar Xenos ////// 


isosurface{  // moon
 
function{(x*x+y*y+z*z-1)+f_granite(x*2,y*2,z*2)*f_agate(x,y,z)*.05 +f_agate(x*100,y*100,z*100)*.001 -f_agate(x*1000,y*1000,z*1000)*.0001}
                  //max_gradient 3.199 
                  accuracy 1/100000
                  contained_by{sphere{0,1}}
                   
                scale .2 rotate <-90,-90,-90> rotate <0,35,0> pigment{rgb .2} translate <.48,.1,-.707>}
                
//                
    
 
/////////////////////////////////////////////////

/*
light_source{0,4
          //fade_power 2
          translate <2,.1,3>*100
          }*/
light_source {<2,.1,3>*1000000, color <2.1,2,1.9>*2 media_attenuation on}
sphere {<2,.1,3>*100, 7.5
	texture {
		pigment {color <2.1,2,1.9>/2}
		finish {ambient 10 diffuse 0}
	}
	no_shadow
}   


///////////////////////////////////////////////////////////////
////////////// Camera ////////////////////////////////////////
 
#declare Clock=clock/3; 


#declare Clock1=clock*(clock<=1); 
#declare Clock2=(clock-1)*(clock>1)*(clock<=2);   
#declare Clock3=(clock-2)*(clock>2);   

//#declare ClockRot=(clock-1)*(clock>1)*(clock<=2)+(clock>2);  
#declare ClockRot=(clock-1)*(clock>1);  

#if (ClockRot>1)
 #declare ClockRot=1;
#end


#declare ClockCount=int(clock);

 
#declare CamStart=<.6,.23,-.6>;
#declare CamEnd=<0,.299,0>;   
//#declare CamMid1= (CamStart*.1) + (CamEnd*.9);  
#declare CamMid1= CamStart;       
#declare CamStart=CamStart+<.4,0,-.4>;
#declare CamMid2= (CamEnd*<.99,.99,.8>) + (CamMid1*<.01,.01,.2>); 


#declare CamPos = (CamMid1*clock) + ( CamStart*(1-clock)); 

#if (clock>1)
     #declare CamPos = (CamMid2*Clock2) + ( CamMid1*(1-Clock2)); 
#end 

#if(clock>2)
   #declare CamPos = (CamEnd*Clock3) + ( CamMid2*(1-Clock3)) ;
#end


camera{
          location CamPos // (CamEnd*(2-(2/(EndClock+1))))+(CamStart*(1-StartClock))   //-.4 // <2,.1,3>/15//<0,0,.3>//<0,0.2989, 0>//<0,.30055,0>//<0,.5,0>    // <.5,0,-1.2> 
          rotate <16,0,-65>*ClockRot
          
          sky <1-ClockRot,1,0>
          right x*image_width/image_height
          look_at (<0,.4,1.19>*ClockRot)+(<0,-.2,.5> *(1-Clock)) //0 // <2,.1,3>*1000000//<0,1,0>//0//<0,-.3,1> //<0,-.4,1> //   
        
        }  


// still cam 
/*
camera{
  location <0,.299,0>//<0,.299,0>//<0,0,.3>//<2,.1,3>/15//<0,0.2989, 0>//<0,.30055,0>//<0,.5,0>    // <.5,0,-1.2> 
  rotate <16,0,-65>
  //up y 
  sky <0,1,0>
  right x*image_width/image_height
  look_at <0,.4,1.19> // 0//<2,.1,3>*1000000//<0,1,0>//<0,-.3,1> //<0,-.4,1> //   

}  
      
      
      
camera{
          location CamMid2 // (CamEnd*(2-(2/(EndClock+1))))+(CamStart*(1-StartClock))   //-.4 // <2,.1,3>/15//<0,0,.3>//<0,0.2989, 0>//<0,.30055,0>//<0,.5,0>    // <.5,0,-1.2> 
          rotate <16,0,-65>
          
          sky <0,1,0>
          right x*image_width/image_height
          look_at <0,.4,1.19> //0 // <2,.1,3>*1000000//<0,1,0>//0//<0,-.3,1> //<0,-.4,1> //   
        
        }   */     
// End of file


